<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use GuzzleHttp\Exception\ClientException;
use Juweliere\UserBundle\Form\AddressFormType;
use Juweliere\UserBundle\Security\UserProvider;
use Symfony\Component\Security\Core\Security;

use App\Entity\User;
use App\Form\ChangePasswordFormType;
use App\Form\ResetPasswordRequestFormType;
use Juweliere\UserBundle\Form\RegistrationFormType;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use SymfonyCasts\Bundle\ResetPassword\Controller\ResetPasswordControllerTrait;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class OrdersController extends BaseController
{

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/orders", name="orders")
     */
    public function list(Request $request): Response
    {
        $template = '@JuweliereUser/pages/user/orders.html.twig';

        $displayOrders = [];

        /** @var \Juweliere\JuwApiClient\Entity\User $orderUser */
        try {
            $orders = $this->juwApi->orders->getByUser($this->getUser()->getId())->getOrders();
            foreach ($orders as $order) {
                if ($order->getStatus() !== "NEW") {
                    $displayOrders[] = $order;
                }
            }
        } catch (ClientException $e) {

        }


        $response = $this->render(
            $template,
            [
                'orders' => $displayOrders,
                'user' => $this->getUser()
            ]);

        return $response;
    }

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/orders/{id}", name="orders_detail")
     */
    public function new(Request $request, $id): Response
    {
        $newAddress=  new \Juweliere\JuwApiClient\Entity\Address();
        $form = $this->createForm(AddressFormType::class, $newAddress);
        $form->handleRequest($request);

        $order = $this->juwApi->orders->get($id);

        $template = '@JuweliereUser/pages/user/orders/detail.html.twig';

        $response = $this->render(
            $template,
            [
                'order' => $order,
                'user' => $this->getUser(),
                'countries' => $this->getCountries()
            ]);

        return $response;
    }
}
