<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\UserBundle\Security\UserProvider;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

abstract class BaseController extends AbstractController
{
    protected JuwApi $juwApi;
    private Session $session;

    /**
     * RecoveryController constructor.
     * @param JuwApi $juwApi
     */
    public function __construct(
        JuwApi $juwApi,
        SessionInterface $session
    ) {
        $this->juwApi = $juwApi;
        $this->session = $session;
    }

    public function sessionRefreshUser()
    {
        $this->session->set(UserProvider::SESSION_KEY_REFRESH_USER, 1);
    }

    protected function getCountries() {
        return array(
            array(
                "code" => "de",
                "label" => "Deutschland"
            ),
            array(
                "code" => "at",
                "label" => "Österreich"
            ),
            array(
                "code" => "ch",
                "label" => "Schweiz"
            )
        );
    }
}
