<?php


namespace Juweliere\UserBundle\Entity;


use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\User\WishlistItem;
use Symfony\Component\Security\Core\User\UserInterface;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class User
 * @ORM\Entity
 * @package Juweliere\UserBundle\Entity
 */
class User implements UserInterface
{

    /** @var array */
    private $roles = [];

    /** @var bool */
    private $isVerified = false;

    /**
     * @ORM\Id
     * @ORM\Column(type="string")
     * @var string
     */
    protected $id;

    /** @var string */
    protected $gender;

    /** @var string */
    protected $firstName;

    /** @var string */
    protected $lastName;

    /** @var string */
    protected $email;

    /** @var string */
    protected $phone;

    /** @var \DateTime */
    protected $birthdate;

    /** @var bool */
    protected $contactPhone;

    /** @var bool */
    protected $contactEmail;

    /** @var Address[]|array */
    protected $addresses;

    /** @var WishlistItem[]|array */
    protected $wishlistItems;

    public function getPassword()
    {
        // TODO: Implement getPassword() method.
    }

    public function getUsername()
    {
        return $this->getEmail();
    }

    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    public function isVerified(): bool
    {
        return $this->isVerified;
    }

    public function setIsVerified(bool $isVerified): self
    {
        $this->isVerified = $isVerified;

        return $this;
    }


    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId($id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * @return array|Address[]
     */
    public function getAddresses(): ?array
    {
        return $this->addresses;
    }

    /**
     * @return array|Address[]
     */
    public function setAddresses($addresses): self
    {
        $this->addresses = $addresses;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function getSalt()
    {
        // not needed when using the "bcrypt" algorithm in security.yaml
    }

    /**
     * @see UserInterface
     */
    public function eraseCredentials()
    {
        // If you store any temporary, sensitive data on the user, clear it here
        // $this->plainPassword = null;
    }


    /**
     *
     */
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    /**
     * @param array|WishlistItem[] $wishlistItems
     * @return User
     */
    public function setWishlistItems(array $wishlistItems): User
    {
        $this->wishlistItems = $wishlistItems;
        return $this;
    }

    /**
     * @return array|WishlistItem[]
     */
    public function getWishlistItems(): ?array
    {
        return $this->wishlistItems;
    }

    /**
     * @param \DateTime $birthdate
     * @return User
     */
    public function setBirthdate(?\DateTime $birthdate): User
    {
        $this->birthdate = $birthdate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBirthdate(): ?\DateTime
    {
        return $this->birthdate;
    }

    /**
     * @param bool $contactPhone
     * @return User
     */
    public function setContactPhone(bool $contactPhone): User
    {
        $this->contactPhone = $contactPhone;
        return $this;
    }

    /**
     * @param bool $contactEmail
     * @return User
     */
    public function setContactEmail(bool $contactEmail): User
    {
        $this->contactEmail = $contactEmail;
        return $this;
    }

    /**
     * @return bool
     */
    public function getContactPhone(): bool
    {
        return $this->contactPhone;
    }

    /**
     * @return bool
     */
    public function getContactEmail(): bool
    {
        return $this->contactEmail;
    }
}
