<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\User\WishlistItem;
use Juweliere\ProductBundle\Entity\Product;
use Juweliere\UserBundle\Form\AddressFormType;
use Juweliere\UserBundle\Security\UserProvider;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Security\Core\Security;

use App\Entity\User;
use App\Form\ChangePasswordFormType;
use App\Form\ResetPasswordRequestFormType;
use Juweliere\UserBundle\Form\RegistrationFormType;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use SymfonyCasts\Bundle\ResetPassword\Controller\ResetPasswordControllerTrait;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class AdressesController extends BaseController
{

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/addresses", name="addresses")
     */
    public function list(Request $request): Response
    {
        $template = '@JuweliereUser/pages/user/addresses.html.twig';

        $response = $this->render(
            $template,
            [
                'user' => $this->getUser(),
                'countries' => $this->getCountries()
            ]);

        return $response;
    }

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/addresses/new", name="addresses_new")
     */
    public function new(Request $request): Response
    {
        $newAddress=  new \Juweliere\JuwApiClient\Entity\Address();
        $form = $this->createForm(AddressFormType::class, $newAddress);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $newAddress->setUser($this->getUser()->getId());
                $this->juwApi->addresses->add($newAddress);
                $this->sessionRefreshUser();

                return $this->redirectToRoute('juweliere_user_user_addresses');

            } catch (\Throwable $e) {
                var_dump($e->getMessage());
                die();
            }

        }

        $template = '@JuweliereUser/pages/user/addresses/new.html.twig';

        $response = $this->render(
            $template,
            [
                'addressForm' => $form->createView(),
                'user' => $this->getUser()
            ]);

        return $response;
    }

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/addresses/{id}/edit", name="addresses_edit")
     */
    public function update(Request $request, $id): Response
    {
        $currentAddress = null;
        /** @var \Juweliere\JuwApiClient\Entity\Address $address */
        foreach ($this->getUser()->getAddresses() as $address) {
            if ($address->getId() == $id) {
                $currentAddress = $address;
                break;
            }
        }

        $form = $this->createForm(AddressFormType::class, $currentAddress);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $address = $this->juwApi->addresses->update($currentAddress);
                $this->sessionRefreshUser();

                return $this->redirectToRoute('juweliere_user_user_addresses');

            } catch (\Throwable $e) {
                var_dump($e->getMessage());
                die();
            }

        }

        $template = '@JuweliereUser/pages/user/addresses/edit.html.twig';

        $response = $this->render(
            $template,
            [
                'addressForm' => $form->createView(),
                'user' => $this->getUser(),
                'address' => $currentAddress
            ]);

        return $response;
    }

    /**
     * @Route("/addresses/{id}/remove", name="addresses_remove")
     * @param Product $product
     * @return Response
     */
    public function removeFromWishlist(Request $request, $id): Response
    {
        try {
            $addresses = $this->getUser()->getAddresses();

            if ($addresses) {
                /** @var \Juweliere\JuwApiClient\Entity\Address $address */
                foreach ($addresses as $address) {
                    if ($address->getId() == $id) {
                        try {
                            $this->juwApi->addresses->delete($address->getId());
                            $this->sessionRefreshUser();
                        } catch (\Throwable $e) {
                            var_dump($e->getMessage());
                            die();
                        }
                    }
                }
            }
        } catch (\Throwable $e) {
            var_dump($e->getMessage());
        }

        if ($request->isXmlHttpRequest()) {
            return new JsonResponse(array("result" => true));
        } else {
            return $this->redirectToRoute('juweliere_user_user_addresses');
        }
    }
}
