<?php

namespace Juweliere\UserBundle\Form;

use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\User;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CountryType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\IsTrue;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfileFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('gender', ChoiceType::class, [
                'label' => 'Anrede',
                'choices' => [
                    'Frau' => 'FEMALE',
                    'Herr' => 'MALE',
                    'Divers' => 'DIVERSE',
                ],
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Anrede an',
                    ]),
                ],
            ])
            ->add('firstName', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihren Vornamen an',
                    ]),
                ],
            ])
            ->add('lastName', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihren Nachnamen an',
                    ]),
                ],
            ])
            ->add('phone', TextType::class , [
                'required' => false
            ])
            ->add('birthdate', BirthdayType::class , [
                'required' => false,
                'widget' => 'single_text'
            ])
            ->add('contactPhone', CheckboxType::class , [
                'required' => false
            ])
            ->add('contactEmail', CheckboxType::class , [
                'required' => false
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => \Juweliere\UserBundle\Entity\User::class,
        ]);
    }
}
