<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\User\Password;
use Juweliere\UserBundle\Form\ProfileFormType;
use Juweliere\UserBundle\Form\PasswordFormType;
use Symfony\Component\Security\Core\Security;

use App\Entity\User;
use App\Form\ChangePasswordFormType;
use App\Form\ResetPasswordRequestFormType;
use Juweliere\UserBundle\Form\RegistrationFormType;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use SymfonyCasts\Bundle\ResetPassword\Controller\ResetPasswordControllerTrait;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class PasswordController extends BaseController
{
    /**
     * Display & process form to request a password reset.
     *
     * @Route("/password", name="password")
     */
    public function edit(Request $request): Response
    {
        $user = $this->getUser();
        $form = $this->createForm(PasswordFormType::class);
        $form->handleRequest($request);

        #var_dump($form->get('passwordnew')->getData());
        #var_dump($form->get('passwordold')->getData());

        $errors = false;

        if ($form->isSubmitted() && $form->isValid() ) {

            try {
                $password = new Password();
                $password->setNewPassword($form->get('passwordnew')->getData());
                $password->setOldPassword($form->get('passwordold')->getData());

                $response = $this->juwApi->users->updatePassword($user->getId(), $password);

                return $this->render('@JuweliereUser/pages/user/password/success.html.twig', [
                ]);
            } catch (\Throwable $exception) {
                $errors = true;
            }



        }/* else {
            var_dump($form->getData());
            foreach ($form->getErrors() as $error) {
                var_dump($error->getMessage());
            }
        }*/

        #var_dump($request);
        #die();

        return $this->render('@JuweliereUser/pages/user/password/edit.html.twig', [
            'passwordForm' => $form->createView(),
            'errors' => $errors
        ]);
    }
}
