<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\ApiBundle\Service\JuwApi;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\Generator\UrlGenerator;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Twig\Environment;
use Sulu\Bundle\WebsiteBundle\Controller\WebsiteController;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class LoginController extends WebsiteController
{
    const SESSION_LOGIN_REDIRECT = "loginRedirect";
    const SESSION_LOGIN_ORIGIN = "loginOrigin";

    private bool $isProd = true;
    private ParameterBagInterface $parameterBag;
    private SessionInterface $session;

    public function __construct(
        ParameterBagInterface $appParams,
        SessionInterface $session
    ) {
        $this->isProd = $appParams->get('kernel.environment') === 'prod';
        $this->parameterBag = $appParams;
        $this->session = $session;
    }

    /**
     * @Route("/login", name="login", options={"expose"=true})
     *
     * @param Request $request
     * @return Response
     *
     */
    public function login(Request $request, AuthenticationUtils $authenticationUtils): Response
    {
        $template = '@JuweliereUser/pages/user/login.html.twig';
        $showGuestOrder = false;

        $guestModeAllowed = boolval($this->parameterBag->get('guest_mode'));;

        if (!is_null($request->get("_target_path")) && $guestModeAllowed) {
            $this->session->set(self::SESSION_LOGIN_REDIRECT, $request->get("_target_path"));

            if ($request->get("_target_path") === "/checkout/address") {
                $showGuestOrder = true;
            }
        }

        if (!is_null($request->get("origin"))) {
            $this->session->set(self::SESSION_LOGIN_ORIGIN, $request->get("origin"));
        }

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();
        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();

        $response = $this->render(
            $template,
            [
                'last_username' => $lastUsername,
                'error' => $error,
                'showGuestOrder' => $showGuestOrder
            ]
        );

        return $response;
    }

    /**
     * @Route("/logout", name="logout")
     */
    public function logout()
    {
        throw new \LogicException('This method can be blank - it will be intercepted by the logout key on your firewall.');
    }
}
