<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\User\Registration;
use Juweliere\UserBundle\Entity\User;
use Juweliere\UserBundle\Form\RegistrationFormType;
use Juweliere\UserBundle\Security\LoginFormAuthenticator;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use SymfonyCasts\Bundle\ResetPassword\Controller\ResetPasswordControllerTrait;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class RegistrationController extends BaseController
{

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/register", name="register")
     */
    public function request(Request $request, LoginFormAuthenticator $loginFormAuthenticator): Response
    {
        $newUser = new Registration();

        $form = $this->createForm(RegistrationFormType::class, $newUser);
        $form->handleRequest($request);

        $error = false;

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $userApi = $this->juwApi->users->create($newUser);

                $user = $loginFormAuthenticator->mapApiUser($userApi);

                $token = new UsernamePasswordToken($user, null, 'main', $user->getRoles());

                $this->get('security.token_storage')->setToken($token);
                $this->get('session')->set('_security_main', serialize($token));
                $this->get('session')->set('_new_user', true);

                return $this->redirectToRoute('juweliere_user_user_register_success');

            } catch (\Throwable $e) {
                $error = true;
            }

        }

        $template = '@JuweliereUser/pages/user/register.html.twig';

        $response = $this->render(
            $template,
            [
                'registrationForm' => $form->createView(),
                'error' => $error
            ]);

        return $response;
    }



    /**
     * Display & process form to request a password reset.
     *
     * @Route("/register/success", name="register_success")
     */
    public function success(Request $request): Response
    {
        if ($redirect = $this->session->get(LoginController::SESSION_LOGIN_REDIRECT)) {
            return new RedirectResponse($redirect);
        }

        #return $this->redirectToRoute('juweliere_user_user_profile_edit');
        $template = '@JuweliereUser/pages/user/profile.html.twig';

        $newUser = $this->get('session')->get('_new_user');

        if ($newUser) {
            $this->get('session')->set('_new_user', false);
            $response = $this->render(
                $template,
                [
                    'user' => $this->getUser(),
                    'newUser' => $newUser
                ]);

            return $response;
        }

        return $this->redirectToRoute('juweliere_user_user_profile');

    }
}
