<?php

namespace Juweliere\UserBundle\User;

use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Twig\Environment;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;

class Mailer
{
    /**
     * @var MailerInterface
     */
    private $mailer;

    /**
     * @var string
     */
    private $subjectPrefix = "";

    /**
     * @var string
     */
    private $mailFrom;
    private $mailFromName;

    /**
     * @param MailerInterface $mailer
     * @param Environment $twig
     * @param $mailFrom
     * @param $mailFromName
     * @param $mailTo
     */
    public function __construct(
        MailerInterface $mailer,
        Environment $twig,
        $mailFrom,
        $mailFromName
    )
    {
        $this->mailer = $mailer;
        $this->twig = $twig;

        $this->mailFrom = $mailFrom;
        $this->mailFromName = $mailFromName;

        if (isset($_SERVER["MAIL_SUBJECT_PREFIX"])) {
            $this->subjectPrefix = $_SERVER["MAIL_SUBJECT_PREFIX"] . " ";
        } elseif (isset($_SERVER["APP_ENV"]) && strtolower($_SERVER["APP_ENV"]) != "prod") {
            $this->subjectPrefix = "(!!! " . $_SERVER["APP_ENV"] . " !!!) ";
        }
    }

    /**
     * @param $email
     * @param $recoverUrl
     * @return int
     */
    public function sendPasswordRecover($email, $recoverUrl)
    {
        /*
        var_dump($this->mailFrom);
        var_dump($this->mailFromName);
        var_dump($order["user"]);
        var_dump($order["user"]["email"]);
        */

        /** @var TemplatedEmail $message */
        $message = (new TemplatedEmail())
            ->subject($this->subjectPrefix . 'Password zurücksetzen')
            ->from(new Address($this->mailFrom, $this->mailFromName))
            ->to($email)
            ->htmlTemplate('@JuweliereUser/mail/user/recovery.html.twig')
            ->context(array("recoverUrl" => $recoverUrl));

        try {
            $this->mailer->send($message);
            return true;
        } catch (\Throwable $e) {
//            var_dump($e->getMessage());
            return false;
        }
    }
}
