<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;


use Sulu\Bundle\WebsiteBundle\Controller\WebsiteController;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\ProductDataProvider;
use Juweliere\UserBundle\Security\UserProvider;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

abstract class BaseController extends WebsiteController
{
    protected JuwApi $juwApi;
    protected Session $session;
    protected ProductDataProvider $productDataProvider;
    protected ParameterBagInterface $parameterBag;

    /**
     * RecoveryController constructor.
     * @param JuwApi $juwApi
     * @param SessionInterface $session
     * @param ProductDataProvider $productDataProvider
     */
    public function __construct(
        JuwApi $juwApi,
        SessionInterface $session,
        ProductDataProvider $productDataProvider,
        ParameterBagInterface $parameterBag
    ) {
        $this->juwApi = $juwApi;
        $this->session = $session;
        $this->parameterBag = $parameterBag;
        $this->productDataProvider = $productDataProvider;
    }

    public function sessionRefreshUser()
    {
        $this->session->set(UserProvider::SESSION_KEY_REFRESH_USER, 1);
    }

    protected function getCountries() {

        $availableCountries =  array(
            array(
                "code" => "de",
                "label" => "Deutschland"
            ),
            array(
                "code" => "at",
                "label" => "Österreich"
            ),
            array(
                "code" => "ch",
                "label" => "Schweiz"
            )
        );

        $countries = explode(",", $this->parameterBag->get('checkout_countries'));

        $displayCountries = array();

        foreach ($availableCountries as $availableCountry) {
            if (in_array($availableCountry["code"], $countries)) {
                $displayCountries[] = $availableCountry;
            }
        }

        return $displayCountries;
    }
}
