<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\User\WishlistItem;
use Juweliere\ProductBundle\Entity\Product;
use Juweliere\UserBundle\Entity\User;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\Annotation\Route;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class StatusController extends BaseController
{

    /**
     * @Route("/status", name="status")
     * @return Response
     */
    public function status(Request $request): Response
    {
        $loggedIn = false;
        try {
            if (!is_null($this->getUser())) {
                $loggedIn = true;
            }

        } catch (\Throwable $e) {

        }
        return new JsonResponse(array("authenticated" => $loggedIn));
    }
}
