<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\UserBundle\Form\DeleteProfileFormType;
use Juweliere\UserBundle\Form\ProfileFormType;
use Symfony\Component\Security\Core\Security;

use App\Entity\User;
use App\Form\ChangePasswordFormType;
use App\Form\ResetPasswordRequestFormType;
use Juweliere\UserBundle\Form\RegistrationFormType;
use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;
use SymfonyCasts\Bundle\ResetPassword\Controller\ResetPasswordControllerTrait;
use SymfonyCasts\Bundle\ResetPassword\Exception\ResetPasswordExceptionInterface;
use SymfonyCasts\Bundle\ResetPassword\ResetPasswordHelperInterface;

/**
 * @Route("/user", name="juweliere_user_user_")
 */
class ProfileController extends BaseController
{

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/profile", name="profile")
     */
    public function request(Request $request): Response
    {
        #return $this->redirectToRoute('juweliere_user_user_profile_edit');
        $template = '@JuweliereUser/pages/user/profile.html.twig';

        $newUser = $this->get('session')->get('_new_user');

        if ($newUser) {
            $this->get('session')->set('_new_user', false);
        }

        $response = $this->render(
            $template,
            [
                'user' => $this->getUser(),
                'newUser' => $newUser
            ]);

        return $response;
    }

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/profile/edit", name="profile_edit")
     */
    public function edit(Request $request): Response
    {
        /** @var \Juweliere\UserBundle\Entity\User $user */
        $user = $this->getUser();

        $form = $this->createForm(ProfileFormType::class, $user);
        #var_dump($request);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $apiUser = new \Juweliere\JuwApiClient\Entity\User();
                $apiUser->setId($user->getId());
                $apiUser->setFirstName($user->getFirstName());
                $apiUser->setLastName($user->getLastName());
                $apiUser->setGender($user->getGender());
                $apiUser->setContactEmail($user->getContactEmail());
                $apiUser->setContactPhone($user->getContactPhone());
                $apiUser->setPhone($user->getPhone());
                $apiUser->setBirthdate($user->getBirthdate());

                $this->juwApi->users->update($apiUser);

                $this->sessionRefreshUser();

                return $this->redirectToRoute('juweliere_user_user_profile');

            } catch (\Throwable $e) {
                var_dump($e->getMessage());
                die();
            }
        }

        $template = '@JuweliereUser/pages/user/profile/edit.html.twig';

        $response = $this->render(
            $template,
            [
                'profileForm' => $form->createView(),
                'user' => $this->getUser()
            ]);

        return $response;
    }



    /**
     * Display & process form to request a password reset.
     *
     * @Route("/profile/delete", name="profile_delete")
     */
    public function delete(Request $request): Response
    {
        /** @var \Juweliere\UserBundle\Entity\User $user */
        $user = $this->getUser();

        $form = $this->createForm(DeleteProfileFormType::class, $user);
        #var_dump($request);
        $form->handleRequest($request);

        $error = false;

        if ($form->isSubmitted() && $form->isValid()) {

            if ($user->getId() === $form->get('id')->getData()) {
                try {
                    if ($this->juwApi->users->delete($user->getId())) {
                        try {
                            $this->juwApi->orders->delete($user->getId());
                        } catch (\Throwable $e) {

                        }
                        $this->container->get('security.token_storage')->setToken(null);
                        return $this->redirectToRoute('juweliere_user_user_deleted');
                    }
                } catch (\Throwable $e) {
                    $this->logger->error("USER DELET ERROR: " . $e->getMessage());
                }

                $error = true;
            }
        }

        $template = '@JuweliereUser/pages/user/profile/delete.html.twig';

        $response = $this->render(
            $template,
            [
                'deleteForm' => $form->createView(),
                'user' => $this->getUser(),
                'error' => $error
            ]);

        return $response;
    }

    /**
     * Display & process form to request a password reset.
     *
     * @Route("/deleted", name="deleted")
     */
    public function deleted(Request $request): Response
    {
        $template = '@JuweliereUser/pages/user/profile/deleted.html.twig';

        $response = $this->render(
            $template);

        return $response;
    }
}
