<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\UserBundle\Entity\JuweliereUser;
use Juweliere\UserBundle\Form\AddressFormType;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route("/user", name: "juweliere_user_user_")]
class AddressesController extends BaseController
{
    /**
     * Display & process form to request a password reset.
     */
    #[Route("/addresses", name: "addresses")]
    public function list() : Response
    {
        $template = '@JuweliereUser/pages/user/addresses.html.twig';
        return $this->render(
            $template,
            [
                'user' => $this->getUser(),
                'countries' => $this->getCountries()
            ]);
    }

    /**
     * Display & process form to request a password reset.
     */
    #[Route('/addresses/new', name: "addresses_new")]
    public function new(Request $request): Response
    {
        $newAddress=  new Address();
        $form = $this->createForm(AddressFormType::class, $newAddress);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $newAddress->setUser($this->getUser()->getId());
                $this->juwApi->addresses->add($newAddress);
                $this->sessionRefreshUser();

                return $this->redirectToRoute('juweliere_user_user_addresses');

            } catch (\Throwable $e) {
                var_dump($e->getMessage());
                die();
            }

        }

        $template = '@JuweliereUser/pages/user/addresses/new.html.twig';

        return $this->render(
            $template,
            [
                'addressForm' => $form->createView(),
                'user' => $this->getUser(),
                'countries' => $this->getCountries()
            ]);
    }

    /**
     * Display & process form to request a password reset.
     */
    #[Route("/addresses/{id}/edit", name: "addresses_edit")]
    public function update(Request $request, $id): Response
    {
        $currentAddress = null;
        /** @var Address $address */

        /** @var JuweliereUser $user */
        $user = $this->getUser();
        foreach ($user->getAddresses() as $address) {
            if ($address->getId() == $id) {
                $currentAddress = $address;
                break;
            }
        }

        $form = $this->createForm(AddressFormType::class, $currentAddress);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $this->juwApi->addresses->update($currentAddress);
                $this->sessionRefreshUser();

                return $this->redirectToRoute('juweliere_user_user_addresses');

            } catch (\Throwable $e) {
                var_dump($e->getMessage());
                die();
            }

        }

        $template = '@JuweliereUser/pages/user/addresses/edit.html.twig';

        return $this->render(
            $template,
            [
                'addressForm' => $form->createView(),
                'user' => $this->getUser(),
                'address' => $currentAddress,
                'countries' => $this->getCountries()
            ]);
    }

    /**
     * @param Request $request
     * @param         $id
     *
     * @return Response
     */
    #[Route("/addresses/{id}/remove", name: "addresses_delete")]
    public function removeFromWishlist(Request $request, $id): Response
    {
        try {
            /** @var JuweliereUser $user */
            $user = $this->getUser();
            $addresses = $user->getAddresses();

            if ($addresses) {
                foreach ($addresses as $address) {
                    if ($address->getId() == $id) {
                        try {
                            $this->juwApi->addresses->delete($address->getId());
                            $this->sessionRefreshUser();
                        } catch (\Throwable $e) {
                            var_dump($e->getMessage());
                            die();
                        }
                    }
                }
            }
        } catch (\Throwable $throwable) {
            var_dump($throwable->getMessage());
        }

        if ($request->isXmlHttpRequest()) {
            return new JsonResponse(["result" => true]);
        } else {
            return $this->redirectToRoute('juweliere_user_user_addresses');
        }
    }
}
