<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Psr\Log\LoggerInterface;
use Sulu\Bundle\WebsiteBundle\Controller\WebsiteController;
use Juweliere\ApiBundle\Service\JuwApi;
use Juweliere\CheckoutBundle\Checkout\ProductDataProvider;
use Juweliere\UserBundle\Security\UserProvider;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

abstract class BaseController extends WebsiteController
{
    protected SessionInterface $session;

    /**
     * RecoveryController constructor.
     */
    public function __construct(
        protected JuwApi $juwApi,
        RequestStack $requestStack,
        protected ProductDataProvider $productDataProvider,
        protected ParameterBagInterface $parameterBag,
        protected LoggerInterface $logger
    ) {
        $this->session = $requestStack->getSession();
    }

    public function sessionRefreshUser(): void
    {
        $this->session->set(UserProvider::SESSION_KEY_REFRESH_USER, 1);
    }

    protected function getCountries(): array
    {
        $availableCountries =  [["code" => "de", "label" => "Deutschland"], ["code" => "at", "label" => "Österreich"], ["code" => "ch", "label" => "Schweiz"]];

        $countries = explode(",", $this->parameterBag->get('checkout_countries'));

        $displayCountries = [];

        foreach ($availableCountries as $availableCountry) {
            if (in_array($availableCountry["code"], $countries)) {
                $displayCountries[] = $availableCountry;
            }
        }

        return $displayCountries;
    }
}
