<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Sulu\Bundle\WebsiteBundle\Controller\WebsiteController;
use Symfony\Component\Routing\Attribute\Route;

#[Route("/user", name: "juweliere_user_user_")]
class LoginController extends WebsiteController
{
    const string SESSION_LOGIN_REDIRECT = "loginRedirect";

    const string SESSION_LOGIN_ORIGIN = "loginOrigin";

    // private bool $isProd = true; // Todo: unused parameter?!

    public function __construct(
        private readonly ParameterBagInterface $parameterBag,
        private readonly RequestStack $requestStack
    ) {
        // $this->isProd = $appParams->get('kernel.environment') === 'prod'; // Todo: unused parameter?!
    }


    #[Route("/login", name: "login", options: ["expose"=> true])]
    public function login(Request $request, AuthenticationUtils $authenticationUtils): Response
    {
        $user = $this->getUser();

        if ($user !== null) {
            return $this->redirectToRoute("juweliere_user_user_profile");
        }

        $template = '@JuweliereUser/pages/user/login.html.twig';
        $showGuestOrder = false;

        $guestModeAllowed = $this->parameterBag->get('guest_mode') == "true";

        if (!is_null($request->get("_target_path"))) {
            $this->requestStack->getSession()->set(self::SESSION_LOGIN_REDIRECT, $request->get("_target_path"));

            if ($request->get("_target_path") === "/checkout/address" && $guestModeAllowed) {
                $showGuestOrder = true;
            }
        }

        if (!is_null($request->get("origin"))) {
            $this->requestStack->getSession()->set(self::SESSION_LOGIN_ORIGIN, $request->get("origin"));
        }

        // get the login error if there is one
        $error = $authenticationUtils->getLastAuthenticationError();
        // last username entered by the user
        $lastUsername = $authenticationUtils->getLastUsername();

        return $this->render(
            $template,
            [
                'last_username' => $lastUsername,
                'error' => $error,
                'showGuestOrder' => $showGuestOrder
            ]
        );
    }

    #[Route("/login/status", name: "login_status", options: ["expose" => true])]
    public function status(): Response
    {
        $user = $this->getUser();

        if ($user !== null) {
            return new JsonResponse(["loggedin" => true]);
        }

        return new JsonResponse(["loggedin" => false], Response::HTTP_UNAUTHORIZED);
    }

    #[Route("/logout", name: "logout")]
    public function logout(): never
    {
        throw new \LogicException('This method can be blank - it will be intercepted by the logout key on your firewall.');
    }
}
