<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\User\Password;
use Juweliere\UserBundle\Form\PasswordFormType;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route("/user", name: "juweliere_user_user_")]
class PasswordController extends BaseController
{
    /**
     * Display & process form to request a password reset.
     */
    #[Route("/password", name: "password")]
    public function edit(Request $request): Response
    {
        $user = $this->getUser();
        $form = $this->createForm(PasswordFormType::class);
        $form->handleRequest($request);

        $errors = false;

        if ($form->isSubmitted() && $form->isValid() ) {
            try {
                $password = new Password();
                $password->setNewPassword($form->get('passwordnew')->getData());
                $password->setOldPassword($form->get('passwordold')->getData());

                $response = $this->juwApi->users->updatePassword($user->getId(), $password);

                return $this->render('@JuweliereUser/pages/user/password/success.html.twig', [
                ]);
            } catch (\Throwable) {
                $errors = true;
            }
        }/* else {
            var_dump($form->getData());
            foreach ($form->getErrors() as $error) {
                var_dump($error->getMessage());
            }
        }*/

        return $this->render('@JuweliereUser/pages/user/password/edit.html.twig', [
            'passwordForm' => $form->createView(),
            'errors' => $errors
        ]);
    }
}
