<?php
declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Juweliere\JuwApiClient\Entity\User;
use Juweliere\UserBundle\Entity\JuweliereUser;
use Juweliere\UserBundle\Form\DeleteProfileFormType;
use Juweliere\UserBundle\Form\ProfileFormType;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(path: '/user', name: 'juweliere_user_user_')]
class ProfileController extends BaseController
{
    /**
     * Display & process form to request a password reset.
     */
    #[Route(path: '/profile', name: 'profile')]
    public function request() : Response
    {
        #return $this->redirectToRoute('juweliere_user_user_profile_edit');
        $template = '@JuweliereUser/pages/user/profile.html.twig';
        $newUser = $this->session->get('_new_user');
        if ($newUser) {
            $this->session->set('_new_user', false);
        }
        return $this->render(
            $template,
            [
                'user' => $this->getUser(),
                'newUser' => $newUser
            ]);
    }

    /**
     * Display & process form to request a password reset.
     */
    #[Route(path: '/profile/edit', name: 'profile_edit')]
    public function edit(Request $request): Response
    {
        /** @var JuweliereUser $user */
        $user = $this->getUser();

        $form = $this->createForm(ProfileFormType::class, $user);
        #var_dump($request);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            try {
                $apiUser = new User();
                $apiUser->setId($user->getId());
                $apiUser->setFirstName($user->getFirstName());
                $apiUser->setLastName($user->getLastName());
                $apiUser->setGender($user->getGender());
                $apiUser->setContactEmail($user->getContactEmail());
                $apiUser->setContactPhone($user->getContactPhone());
                $apiUser->setPhone($user->getPhone());
                $apiUser->setBirthdate($user->getBirthdate());

                $this->juwApi->users->update($apiUser);

                $this->sessionRefreshUser();

                return $this->redirectToRoute('juweliere_user_user_profile');

            } catch (\Throwable $e) {
                var_dump($e->getMessage());
                die();
            }
        }

        $template = '@JuweliereUser/pages/user/profile/edit.html.twig';

        return $this->render(
            $template,
            [
                'profileForm' => $form->createView(),
                'user' => $this->getUser()
            ]);
    }



    /**
     * Display & process form to request a password reset.
     */
    #[Route(path: '/profile/delete', name: 'profile_delete')]
    public function delete(Request $request): Response
    {
        /** @var \Juweliere\UserBundle\Entity\User $user */
        $user = $this->getUser();

        $form = $this->createForm(DeleteProfileFormType::class, $user);
        #var_dump($request);
        $form->handleRequest($request);

        $error = false;

        if ($form->isSubmitted() && $form->isValid()) {

            if ($user->getId() === $form->get('id')->getData()) {
                try {
                    if ($this->juwApi->users->delete($user->getId())) {
                        try {
                            $this->juwApi->orders->delete($user->getId());
                        } catch (\Throwable) {

                        }

                        $this->container->get('security.token_storage')->setToken(null);
                        return $this->redirectToRoute('juweliere_user_user_deleted');
                    }
                } catch (\Throwable $e) {
                    $this->logger->error("USER DELETE ERROR: " . $e->getMessage());
                }

                $error = true;
            }
        }

        $template = '@JuweliereUser/pages/user/profile/delete.html.twig';

        return $this->render(
            $template,
            [
                'deleteForm' => $form->createView(),
                'user' => $this->getUser(),
                'error' => $error
            ]);
    }

    /**
     * Display & process form to request a password reset.
     */
    #[Route(path: '/deleted', name: 'deleted')]
    public function deleted() : Response
    {
        $template = '@JuweliereUser/pages/user/profile/deleted.html.twig';
        return $this->render(
            $template);
    }
}
