<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Controller;

use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route(path: '/user', name: 'juweliere_user_user_')]
class StatusController extends BaseController
{

    #[Route(path: '/status', name: 'status')]
    public function status() : Response
    {
        $loggedIn = false;
        try {
            if (!is_null($this->getUser())) {
                $loggedIn = true;
            }

        } catch (\Throwable) {

        }

        return new JsonResponse(["authenticated" => $loggedIn]);
    }
}
