<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\DataProvider;

use Juweliere\ProductBundle\ElasticSearch\ElasticProductsParser;
use Juweliere\ProductBundle\Service\ProductDataHelper;

readonly class ProductDataProvider
{
    /**
     * ProductDataProvider constructor.
     */
    public function __construct(private ElasticProductsParser $productsParser, private ProductDataHelper $priceHelper, private string $imageBaseUrl)
    {
    }

    /**
     * @param string $sku
     *
     * @return array|null
     * @throws \Exception
     */
    public function getProductBySku(string $sku): ?array
    {
        $product = $this->productsParser->getSingleProduct($sku);
        $product["images"] = $this->getFullPathImages($product);
        $product["price"] = $this->getPrice($product);

        return $product;
    }

    /**
     * @throws \Exception
     */
    private function getPrice(array $product): int|float {

        $priceData = $this->priceHelper->getPrice($product);

        if (empty($price)) {
            $price = $priceData["rrp"]["value"] * 100;

            if ($priceData["specialPrice"]) {
                $price = $priceData["rrp"]["actualPrice"] * 100;
            }
        }

        return $price;
    }

    /**
     * @param array  $product
     * @param string $dimension
     *
     * @return array
     */
    private function getFullPathImages(array $product, string $dimension = "250x250"): array
    {
        $images = [];

        if (!empty($product["gallery"])) {
            foreach ($product["gallery"] as $image) {
                $images[] = $this->imageBaseUrl . $dimension . "/" . $image["path"];
            }
        } else {
            $images[] = $this->imageBaseUrl . $dimension . "/" . $product["image"];
        }

        return $images;
    }
}
