<?php

namespace Juweliere\UserBundle\DependencyInjection;

use Juweliere\UserBundle\User\Mailer;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class JuweliereUserExtension extends Extension
{
    /**
     *
     * @throws \Exception
     */
    #[\Override]
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__.'/../../config')
        );
        $loader->load('services.yaml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $definition = $container->getDefinition(Mailer::class);
        $definition->replaceArgument(1, $config['mail']['from']);
        $definition->replaceArgument(2, $config['mail']['from_name']);
    }
}
