<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Entity;

use DateTime;
use Juweliere\JuwApiClient\Entity\Address;
use Juweliere\JuwApiClient\Entity\User\WishlistItem;
use Symfony\Component\Security\Core\User\UserInterface;
use Doctrine\ORM\Mapping as ORM;

/**
 * Class User
 * @package Juweliere\UserBundle\Entity
 */
#[ORM\Entity]
class JuweliereUser implements UserInterface
{

    private array $roles = [];

    private bool $isVerified = false;

    #[ORM\Id]
    #[ORM\Column(type: 'string')]
    protected string $id;

    protected ?string $gender = null;

    protected ?string $firstName = null;

    protected ?string $lastName = null;

    protected string $email;

    protected ?string $phone = null;

    protected ?\DateTime $birthdate = null;

    protected ?bool $contactPhone = null;

    protected ?bool $contactEmail = null;

    /** @var Address[]|array */
    protected array $addresses;

    /** @var WishlistItem[]|array */
    protected array $wishlistItems;

    public function getPassword(): void
    {
        // TODO: Implement getPassword() method.
    }

    public function getUsername(): ?string
    {
        return $this->getEmail();
    }

    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    public function isVerified(): bool
    {
        return $this->isVerified;
    }

    public function setIsVerified(bool $isVerified): self
    {
        $this->isVerified = $isVerified;

        return $this;
    }


    public function getId(): ?string
    {
        return $this->id;
    }

    public function setId(string $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getGender(): ?string
    {
        return $this->gender;
    }

    public function setGender(?string $gender): self
    {
        $this->gender = $gender;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getPhone(): ?string
    {
        return $this->phone;
    }

    public function setPhone(?string $phone): self
    {
        $this->phone = $phone;

        return $this;
    }

    /**
     * @return array|null
     */
    public function getAddresses(): ?array
    {
        return $this->addresses;
    }

    /**
     * @param array $addresses
     *
     * @return JuweliereUser
     */
    public function setAddresses(array $addresses): self
    {
        $this->addresses = $addresses;

        return $this;
    }

    /**
     * @see UserInterface
     */
    public function getSalt(): void
    {
        // not needed when using the "bcrypt" algorithm in security.yaml
    }

    /**
     * @see UserInterface
     */
    #[\Override]
    public function eraseCredentials(): void
    {
        // If you store any temporary, sensitive data on the user, clear it here
        // $this->plainPassword = null;
    }


    /**
     *
     */
    #[\Override]
    public function getRoles(): array
    {
        $roles = $this->roles;
        // guarantee every user at least has ROLE_USER
        $roles[] = 'ROLE_USER';

        return array_unique($roles);
    }

    /**
     * @param array|WishlistItem[] $wishlistItems
     */
    public function setWishlistItems(array $wishlistItems): JuweliereUser
    {
        $this->wishlistItems = $wishlistItems;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getWishlistItems(): ?array
    {
        return $this->wishlistItems;
    }

    /**
     * @param DateTime|null $birthdate
     *
     * @return JuweliereUser
     */
    public function setBirthdate(?DateTime $birthdate): JuweliereUser
    {
        $this->birthdate = $birthdate;
        return $this;
    }

    /**
     * @return DateTime|null
     */
    public function getBirthdate(): ?DateTime
    {
        return $this->birthdate;
    }

    public function setContactPhone(bool $contactPhone): JuweliereUser
    {
        $this->contactPhone = $contactPhone;
        return $this;
    }

    public function setContactEmail(bool $contactEmail): JuweliereUser
    {
        $this->contactEmail = $contactEmail;
        return $this;
    }

    public function getContactPhone(): bool
    {
        return $this->contactPhone;
    }

    public function getContactEmail(): bool
    {
        return $this->contactEmail;
    }

    public function getUserIdentifier(): string
    {
        return $this->email;
    }
}
