<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Form;

use Juweliere\JuwApiClient\Entity\Address;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class AddressFormType extends AbstractType
{
    #[\Override]
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('gender', ChoiceType::class, [
                'label' => 'Anrede',
                'choices' => [
                    'Frau' => 'FEMALE',
                    'Herr' => 'MALE',
                    'Divers' => 'DIVERSE',
                ],
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Anrede an',
                    ]),
                ],
            ])
            ->add('firstName', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihren Vornamen an',
                    ]),
                ],
            ])
            ->add('lastName', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihren Nachnamen an',
                    ]),
                ],
            ])
            ->add('street', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Straße an',
                    ]),
                ],
            ])
            ->add('street2')
            ->add('postcode', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Postleitzahl an',
                    ]),
                ],
            ])
            ->add('city', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Stadt an',
                    ]),
                ],
            ])
            ->add('country', ChoiceType::class, [
                'choices' => [
                    'Deutschland' => 'de',
                    'Österreich' => 'at',
                    'Schweiz' => 'ch'
                ],
                'preferred_choices' => ['de'],
            ])
            ->add('phone', TextType::class, [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Telefonnummer an',
                    ]),
                ],
            ])
        ;
    }

    #[\Override]
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Address::class,
        ]);
    }
}
