<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\Form;

use Juweliere\UserBundle\Entity\JuweliereUser;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\BirthdayType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;

class ProfileFormType extends AbstractType
{
    #[\Override]
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('gender', ChoiceType::class, [
                'label' => 'Anrede',
                'choices' => [
                    'Frau' => 'FEMALE',
                    'Herr' => 'MALE',
                    'Divers' => 'DIVERSE',
                ],
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihre Anrede an',
                    ]),
                ],
            ])
            ->add('firstName', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihren Vornamen an',
                    ]),
                ],
            ])
            ->add('lastName', TextType::class , [
                'constraints' => [
                    new NotBlank([
                        'message' => 'Bitte geben Sie ihren Nachnamen an',
                    ]),
                ],
            ])
            ->add('phone', TextType::class , [
                'required' => false
            ])
            ->add('birthdate', BirthdayType::class , [
                'required' => false,
                'widget' => 'single_text'
            ])
            ->add('contactPhone', CheckboxType::class , [
                'required' => false
            ])
            ->add('contactEmail', CheckboxType::class , [
                'required' => false
            ])
        ;
    }

    #[\Override]
    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => JuweliereUser::class,
        ]);
    }
}
