<?php

declare(strict_types=1);

namespace Juweliere\UserBundle\User;

use Symfony\Bridge\Twig\Mime\TemplatedEmail;
use Symfony\Component\Mailer\MailerInterface;
use Symfony\Component\Mime\Address;

class Mailer
{
    private string $subjectPrefix = "";

    /**
     * @param MailerInterface $mailer
     * @param string          $mailFrom
     * @param string          $mailFromName
     */
    public function __construct(
        private readonly MailerInterface $mailer,
        private readonly string          $mailFrom,
        private readonly string          $mailFromName
    )
    {
        if (isset($_SERVER["MAIL_SUBJECT_PREFIX"])) {
            $this->subjectPrefix = $_SERVER["MAIL_SUBJECT_PREFIX"] . " ";
        } elseif (isset($_SERVER["APP_ENV"]) && strtolower((string) $_SERVER["APP_ENV"]) != "prod") {
            $this->subjectPrefix = "(!!! " . $_SERVER["APP_ENV"] . " !!!) ";
        }
    }

    /**
     * @param Address|string $email
     * @param                $recoverUrl
     *
     * @return bool
     */
    public function sendPasswordRecover(Address|string $email, $recoverUrl): bool
    {
        /*
        var_dump($this->mailFrom);
        var_dump($this->mailFromName);
        var_dump($order["user"]);
        var_dump($order["user"]["email"]);
        */

        $message = new TemplatedEmail()
            ->subject($this->subjectPrefix . 'Passwort zurücksetzen')
            ->from(new Address($this->mailFrom, $this->mailFromName))
            ->to($email)
            ->htmlTemplate('@JuweliereUser/mail/user/recovery.html.twig')
            ->context(["recoverUrl" => $recoverUrl]);

        try {
            $this->mailer->send($message);
            return true;
        } catch (\Throwable) {
            return false;
        }
    }
}
